#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 DeepSkyBlue
#property indicator_color2 Tomato
#property indicator_color3 Teal
#property indicator_color4 Teal
#property indicator_color5 Black

extern int Amplitude = 2;

bool nexttrend;
double minh, maxl, up[], down[], trend[], atrlo[], atrhi[];

int init () {
  SetIndexBuffer (0, up);
  SetIndexStyle (0, DRAW_LINE);
  SetIndexBuffer (1, down);
  SetIndexStyle (1, DRAW_LINE);
  SetIndexBuffer (2, atrlo);
  SetIndexStyle (2, DRAW_LINE);
  SetIndexBuffer (3, atrhi);
  SetIndexStyle (3, DRAW_LINE);
  SetIndexBuffer (4, trend);
  SetIndexEmptyValue (0, 0.0);
  SetIndexEmptyValue (1, 0.0);
  SetIndexEmptyValue (4, 0.0);
  nexttrend = 0;
  minh = High[Bars - 1];
  maxl = Low[Bars - 1];
  return (0);
}

int start () {
  double atr, ll, hh, lma, hma;
  int workbar = 1;
  int c = IndicatorCounted ();

  if (c < 0) {
    return (- 1);
  }

  for (int i = Bars - 1 - c; i >= workbar; i --) {
    ll = iLow (Symbol (), Period (),
      iLowest (Symbol (), Period (), MODE_LOW, Amplitude, i));
    hh = iHigh (Symbol (), Period (),
      iHighest (Symbol (), Period (), MODE_HIGH, Amplitude, i));
    lma = iMA (NULL, 0, Amplitude, 0, MODE_SMA, PRICE_LOW, i);
    hma = iMA (NULL, 0, Amplitude, 0, MODE_SMA, PRICE_HIGH, i);
    trend[i] = trend[i + 1];
    atr = iATR (Symbol (), 0, 100, i) / 2;

    if (nexttrend == 1) {
      maxl = MathMax (ll, maxl);

      if (hma < maxl
      && Close[i] < Low[i + 1]) {
        trend[i] = 1;
        nexttrend = 0;
        minh = hh;
      }
    }

    if (nexttrend == 0) {
      minh = MathMin (hh, minh);

      if (lma > minh
      && Close[i] > High[i + 1]) {
        trend[i] = 0;
        nexttrend = 1;
        maxl = ll;
      }
    }

    if (trend[i] == 0.0) {
      if (trend[i + 1] != 0.0) {
        up[i] = down[i + 1];
        up[i + 1] = up[i];
      } else {
        up[i] = MathMax (maxl, up[i + 1]);
      }

      atrhi[i] = up[i] + atr;
      atrlo[i] = up[i] - atr;
      down[i] = 0.0;
    } else {
      if (trend[i + 1] != 1.0) {
        down[i] = up[i + 1];
        down[i + 1] = down[i];
      } else {
        down[i] = MathMin (minh, down[i + 1]);
      }

      atrhi[i] = down[i] + atr;
      atrlo[i] = down[i] - atr;
      up[i] = 0.0;
    }
  }

  return (0);
}
