//+------------------------------------------------------------------+
//|                                                         Q2MA.mq4 |
//|                      Copyright  2011, MetaQuotes Software Corp. |
//|                             http://www.mql4.com/ru/users/rustein |
//-------------------------------------------------------------------+

//-------------------------------------------------------------------+
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Green
#property indicator_color4 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 1  
#property indicator_width4 1  
//-------------------------------------------------------------------+
extern bool Alerts=true;
//-------------------------------------------------------------------+
extern int  MAPeriod =13;
extern int  MAMode=0; // 0=SMA,1=EMA,2=SSMA,3=LWMA
//-------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|            DO NOT MODIFY ANYTHING BELOW THIS LINE!!!             |
//+------------------------------------------------------------------+

//-------------------------------------------------------------------+
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double trend[];
datetime barTime=0;
double prevTicTrend=0;
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(5);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(2,ExtMapBuffer3); SetIndexStyle(2,DRAW_ARROW); SetIndexArrow(2,174);
   SetIndexBuffer(3,ExtMapBuffer4); SetIndexStyle(3,DRAW_ARROW); SetIndexArrow(3,174);
   SetIndexBuffer(4,trend);
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
int start()
  {

  int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=1+1;

//-----   
   for(int i=limit; i>=0; i--)
     {
      ExtMapBuffer1[i] = iMA(NULL,0,MAPeriod,0,MAMode,PRICE_CLOSE,i);
      ExtMapBuffer2[i] = iMA(NULL,0,MAPeriod,0,MAMode,PRICE_OPEN,i);
      ExtMapBuffer3[i] = EMPTY_VALUE;
      ExtMapBuffer4[i] = EMPTY_VALUE;
      trend[i]         = trend[i+1];
      //-----     
      double dist = iATR(NULL,0,0,i);
      double diff = (ExtMapBuffer1[i]-ExtMapBuffer2[i]);
      //-----
      if(diff > 0) trend[i] =  1;
      if(diff < 0) trend[i] = -1;
      if(trend[i]!=trend[i+1])
         if(trend[i]==1)
            ExtMapBuffer3[i] = ExtMapBuffer1[i]-dist;
      else ExtMapBuffer4[i] = ExtMapBuffer1[i]+dist;
      //+------------------------------------------------------------------+   
      if(Alerts && i==0 && trend[0]!=trend[i+1])
        {
         if(barTime!=Time[0])
           {
            if(trend[0]==1)
              {
               Alert("Q2MA BUY! "+Symbol()+" "+Period());
              }
            if(trend[0]==-1)
              {
               Alert("Q2MA SELL! "+Symbol()+" "+Period());
              }
           }
         barTime=Time[0];
         if(prevTicTrend!=trend[0])
           {
            PlaySound("alert.wav");
           }
         prevTicTrend=trend[0];
        }
     }
   return(0);
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
