// ++
//      Ultimate MACD                                                           UltimateMACD.mq4 
//    MACD    ,  ,   MT4.                  
//   ,     ,    ,      
//       . ,      
//      :)                                                            
//     ,     ,     . 
//          (.mq4),        
//   .                                                                             
// ----------------------------------------------------------------------------------------------
//      [release 1] 05.09.2009                                                                   
//  () .                                        
//  (+)                                                        
//  (!)-,      EMA (   )  
//  (+)       ("" MACD)       
//  (+)   ZeroLag MA,     C/D      
//  (+)       ,           
//  (+)     ,     _________________________________
//        MA                                         |  xp3rienced, Ekaterinburg 2009 
// ++
#property copyright " xp3rienced"
#property link      "no4ta[at]inbox.ru"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 CadetBlue
#property indicator_color2 Red
#property indicator_width1 2
#property indicator_width2 1
//#property indicator_style2 STYLE_DOT

//====[   ]====
extern int FastMA_Period = 12;            //  "" 
extern int SlowMA_Period = 26;            //  "" 
extern int SignalMA_Period = 9;           //    
extern int FastMA_Method = 1;             //   ""  (  : 0-SMA, 1-EMA, 2-SMMA, 3-LWMA)
extern int SlowMA_Method = 1;             //   "" 
extern int SignalMA_Method = 1;           //     
extern int FastMA_Price = 0;              //   "" 
extern int SlowMA_Price = 0;              //   "" 
extern bool Linear = false;               // true -   ; false - 
extern bool ZeroLag_Algorithm = false;    //   ZeroLag MA        
extern string __Symbol = "";               //  .   -   
extern int TimeFrame = 0;                 // .  -   , 0    
/*    -   ,   . /
/ -""      ,       /
/       .                                               */
extern string CI_Name = "";               //  ,       .   -  
extern int CI_LineNum = 0;                //   
extern int CI_ParamCount = 0;             //  ,  
extern double CI_Param1 = 0;              // -.
extern double CI_Param2 = 0;              //  |
extern double CI_Param3 = 0;              //  |
extern double CI_Param4 = 0;              //   >   ,    
extern double CI_Param5 = 0;              //  |
extern double CI_Param6 = 0;              //  |
extern double CI_Param7 = 0;              // -'

                                          //====[   ]====
double MACD[];
double SignalLine[];
double FastMA[];
double SlowMA[];
double CI_Buffer[];
double ZL_SignalLine[];

//====[    ]====
string symbol;
double ZL_EMA,ZL_EMA_P,ZL_EMA_Q;              // ,      ZeroLag
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(6);
   IndicatorDigits(Digits+1);
//----   
   SetIndexBuffer(0,MACD);
   SetIndexBuffer(1,SignalLine);
   SetIndexBuffer(2,FastMA);
   SetIndexBuffer(3,SlowMA);
   SetIndexBuffer(4,CI_Buffer);
   SetIndexBuffer(5,ZL_SignalLine);
//----  
   if(Linear) SetIndexStyle(0,DRAW_LINE); else SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexDrawBegin(1,SignalMA_Period);
//----    ,    
   string ShortName=StringConcatenate("Ultimate MACD(",FastMA_Period,",",SlowMA_Period,",",SignalMA_Period);
   if(ZeroLag_Algorithm) ShortName=StringConcatenate(ShortName,",ZeroLag)");
   else ShortName=StringConcatenate(ShortName,")");
   if(CI_Name != "") ShortName = StringConcatenate(ShortName, " on ", CI_Name);
   if(__Symbol != "") symbol = __Symbol;
   else symbol = Symbol();
   ShortName=StringConcatenate(ShortName," [",symbol,",",TimeFrameStr(TimeFrame),"]");
   IndicatorShortName(ShortName);
   SetIndexLabel(0,"MACD");
   SetIndexLabel(1,"Signal");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+
int deinit()
  {
//----

//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                         |
//+------------------------------------------------------------------+
int start()
  {
   int limit=Bars-IndicatorCounted();
   if(limit<Bars) limit++;                           //    
//----  ""  
   CalcMA(limit);
//---- ,    ..
   if(ZeroLag_Algorithm) CalcZeroLagMACD(limit);       // ..   ZeroLag MA
   else CalcMACD(limit);                               // ..   
//----
   return(0);
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
void CalcMA(int limit)
  {
   if(CI_Name!="") //    ,     
     {
      for(int i=0; i<limit; i++) CI_Buffer[i]=GetIndicatorData(i);
      for(i=0; i<limit; i++)
        {
         FastMA[i] = iMAOnArray(CI_Buffer, Bars, FastMA_Period, 0, FastMA_Method, i);
         SlowMA[i] = iMAOnArray(CI_Buffer, Bars, SlowMA_Period, 0, SlowMA_Method, i);
        }
     }
   else                          //      
     {
      for(i=0; i<limit; i++)
        {
         FastMA[i] = iMA(symbol, TimeFrame, FastMA_Period, 0, FastMA_Method, FastMA_Price, i);
         SlowMA[i] = iMA(symbol, TimeFrame, SlowMA_Period, 0, SlowMA_Method, SlowMA_Price, i);
        }
     }
  }
//+------------------------------------------------------------------+
//|                  MACD  ZeroLag MA                |
//+------------------------------------------------------------------+
void CalcZeroLagMACD(int limit)
  {
   for(int i=0; i<limit; i++)
     {
      ZL_EMA=iMAOnArray(FastMA,Bars,FastMA_Period,0,FastMA_Method,i);
      ZL_EMA_P=FastMA[i]+FastMA[i]-ZL_EMA;
      ZL_EMA=iMAOnArray(SlowMA,Bars,SlowMA_Period,0,SlowMA_Method,i);
      ZL_EMA_Q= SlowMA[i]+SlowMA[i]-ZL_EMA;
      MACD[i] = ZL_EMA_P-ZL_EMA_Q;
     }
   for(i=0; i<limit; i++)
      ZL_SignalLine[i]=iMAOnArray(MACD,Bars,SignalMA_Period,0,SignalMA_Method,i);
   for(i=0; i<limit; i++)
     {
      ZL_EMA=iMAOnArray(ZL_SignalLine,Bars,SignalMA_Period,0,MODE_EMA,i);
      SignalLine[i]=ZL_SignalLine[i]+ZL_SignalLine[i]-ZL_EMA;
     }
  }
//+------------------------------------------------------------------+
//|              MACD  SMA/EMA/SMMA/LWMA             |
//+------------------------------------------------------------------+
void CalcMACD(int limit)
  {
   for(int i=0; i<limit; i++) MACD[i]=FastMA[i]-SlowMA[i];
   for(i=0; i<limit; i++)
      SignalLine[i]=iMAOnArray(MACD,Bars,SignalMA_Period,0,SignalMA_Method,i);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double GetIndicatorData(int shift)
  {
//----   :-!
   switch(CI_ParamCount)
     {
      case 1: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_LineNum, shift));
      case 2: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_LineNum, shift));
      case 3: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_Param3, CI_LineNum, shift));
      case 4: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_Param3, CI_Param4, CI_LineNum, shift));
      case 5: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_Param3, CI_Param4, CI_Param5, CI_LineNum, shift));
      case 6: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_Param3, CI_Param4, CI_Param5, CI_Param6, CI_LineNum, shift));
      case 7: return(iCustom(symbol, TimeFrame, CI_Name, CI_Param1, CI_Param2, CI_Param3, CI_Param4, CI_Param5, CI_Param6, CI_Param7, CI_LineNum, shift));
      default: return(iCustom(symbol,TimeFrame,CI_Name,CI_LineNum,shift));
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
string TimeFrameStr(int period)
  {
   switch(period)
     {
      case 0: return(TimeFrameStr(Period()));
      case 1: return("M1");
      case 5: return("M5");
      case 15: return("M15");
      case 30: return("M30");
      case 60: return("H1");
      case 240: return("H4");
      case 1440: return("D1");
      case 10080: return("W1");
      case 43200: return("MN");
      default: return(TimeFrameStr(Period()));
     }
  }
//+------------------------------------------------------------------+
